ConvertObjToJSON <- function(
  obj,
  dataframe = 'rows',
  asMatrix = FALSE
) {
  if (!is.null(obj)) {
    if (asMatrix && is.data.frame(obj)) {
      obj <- list(
        colNames = colnames(obj),
        data = as.matrix(obj)
      )
    }
    json <- jsonlite::toJSON(obj, dataframe = dataframe, auto_unbox = TRUE, na = 'null', null = 'null')
  } else {
    json <- NULL
  }

  return(json)
}
