% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDiagnosisYearDensityPlot.R
\name{GetDiagnosisYearDensityPlot}
\alias{GetDiagnosisYearDensityPlot}
\title{GetDiagnosisYearDensityPlot}
\usage{
GetDiagnosisYearDensityPlot(
  plotData,
  colorPalette = c("#69b023", "#7bbcc0", "#9d8b56", "#ce80ce"),
  genderLabels = c(M = "Male", F = "Female", O = "Other"),
  xLimits = NULL,
  markerLocations = NULL
)
}
\arguments{
\item{plotData}{Data table object. Required.}

\item{colorPalette}{Character vector of colors for plotted
series. Optional. Default = \code{c("#c7c7c7", "#69b023", "#7bbcc0",
"#9d8b56", "#ce80ce")}.}

\item{genderLabels}{Named vector of mapping from Gender code to label.
Optional. Default = \code{c("M" = "Male", "F" = "Female", "O" = "Other")}}

\item{xLimits}{Vector of two numbers (years), lower and upper limit for the
x axis. Optional. Default = \code{NULL}.}

\item{markerLocations}{Vector of numbers (years) for positions of vertical
dashed lines. Optional. Default = \code{NULL}.}
}
\value{
ggplot2 object
}
\description{
Get density plot of diagnosis year
}
\examples{
\dontrun{
GetDiagnosisYearDensityPlot(plotData)
}

}
