% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetParamInfoFromAdjustSpec.R
\name{GetParamInfoFromAdjustSpec}
\alias{GetParamInfoFromAdjustSpec}
\title{GetParamInfoFromAdjustSpec}
\usage{
GetParamInfoFromAdjustSpec(paramSpecs, infoType = "value")
}
\arguments{
\item{paramSpecs}{List of parameter specifications. Required.}

\item{infoType}{Type of information to extract from the parameter
specification. Optional. Default = "value".}
}
\value{
List of parameters of shape \code{[paramName]} = \code{[paramValue]}
}
\description{
Extract parameters from an adjustment specification. Values are provided as
a list.
}
\examples{
paramSpecs <- list(
  nimp = list(
    label = "Number of imputations",
    input = "numeric",
    value = 2
  )
)
GetParamInfoFromAdjustSpec(paramSpecs)
# $nimp
# [1] 2

GetParamInfoFromAdjustSpec(paramSpecs, infoType = "label")
GetParamInfoFromAdjustSpec(paramSpecs, infoType = "input")

}
