% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetRDPlots.R
\name{GetRDPlots}
\alias{GetRDPlots}
\title{GetRDPlots}
\usage{
GetRDPlots(
  stratum = NULL,
  plotData,
  isOriginalData = TRUE,
  colorPalette = c(Bounds = "#c7c7c7", `Estimated total` = "#69b023", Reported =
    "#7bbcc0", Imputed = "#9d8b56")
)
}
\arguments{
\item{stratum}{String denoting for which value of Stratum column in \code{plotData} to make
plots. If not specifed, then plots are created for total. Optional. Default = \code{NULL}.}

\item{plotData}{Data table object. Required.}

\item{isOriginalData}{Logical indicating that \code{plotData} is based on data before any other
adjustment. Optional. Default = TRUE.}

\item{colorPalette}{Character vector of length 4 with colors for plotted series. Optional.
Default = \code{c('#c7c7c7', '#69b023', '#7bbcc0', '#9d8b56', '#ce80ce')}.}
}
\value{
Data table object
}
\description{
Get plots for reporting delay adjustment artifacts.
}
\examples{
\dontrun{
GetRDPlots(stratum, plotData, isOriginalData, colorPalette)
}

}
