% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunAdjustments.R
\name{RunAdjustments}
\alias{RunAdjustments}
\title{RunAdjustments}
\usage{
RunAdjustments(
  data,
  adjustmentSpecs = list(),
  diagYearRange = NULL,
  notifQuarterRange = NULL,
  seed = NULL
)
}
\arguments{
\item{data}{data table object on which adjustments should be applied. Required.}

\item{adjustmentSpecs}{List of adjustment specifications to execute. Optional.
Default = \code{list()}.}

\item{diagYearRange}{Numeric vector of length two with lower and upper bound for diagnosis year.
Optional. Default = \code{NULL}.}

\item{notifQuarterRange}{Numeric vector of length two with lower and upper bound for
notification quarter. Optional. Default = \code{NULL}.}

\item{seed}{Random seed. Optional. Default = NULL}
}
\value{
data table object after adjustments applied.
}
\description{
Execute adjustments specified in \code{adjustmentFileNames}.
}
\examples{
\dontrun{
RunAdjustments(data)
}

}
