% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteExcelFile.R
\name{WriteExcelFile}
\alias{WriteExcelFile}
\title{WriteExcelFile}
\usage{
WriteExcelFile(data, fileName, sheetName = "DATA", template = NULL)
}
\arguments{
\item{data}{Object to save. Required.}

\item{fileName}{Name of the saved file. Required.}

\item{sheetName}{Name of the sheet were exported data should be saved. Default = 'DATA'.}

\item{template}{Full path to input template Excel file. Optional. Default = \code{NULL}.}
}
\value{
NULL (invisibly)
}
\description{
Write an object to an Excel file.
}
\examples{
\dontrun{
WriteExcelFile(
  data = appMgr$HIVModelMgr$PlotData,
  fileName = 'D:/Charts.xlsm',
  template = GetSystemFile('templates', 'Charts.xlsm'),
  sheetName = 'DATA'
)
WriteExcelFile(
  data = appMgr$HIVModelMgr$PlotData,
  fileName = 'D:/Charts_withoutMacro.xlsx',
  template = GetSystemFile('templates', 'Charts_withoutMacro.xlsx'),
  sheetName = 'DATA'
)
}

}
